-- 
-- Database: `overload`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_containsuri`
-- 

CREATE TABLE `overload_containsuri` (
  `itemid` bigint(20) NOT NULL default '0',
  `uri` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  KEY `uri` (`uri`),
  KEY `itemid` (`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_enclosure`
-- 

CREATE TABLE `overload_enclosure` (
  `id` bigint(20) NOT NULL auto_increment,
  `itemid` bigint(20) NOT NULL,
  `uri` varchar(1000) collate utf8_unicode_ci NOT NULL,
  `length` bigint(20) NOT NULL,
  `mimetype` varchar(100) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `itemid` (`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=462 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_feed`
-- 

CREATE TABLE `overload_feed` (
  `id` bigint(20) NOT NULL auto_increment,
  `uri` varchar(500) collate utf8_unicode_ci NOT NULL,
  `siteuri` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `name` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `subtitle` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `hasfavicon` int(11) NOT NULL default '0',
  `feedimage` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `feedimagedesc` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `added` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastupdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastupdatesuccessful` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=108 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_item`
-- 

CREATE TABLE `overload_item` (
  `id` bigint(20) NOT NULL auto_increment,
  `feedid` bigint(20) NOT NULL default '0',
  `title` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `content` longtext collate utf8_unicode_ci NOT NULL,
  `author` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `uri` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `relateduri` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `hasuris` int(11) NOT NULL default '0',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `datetimestamp` varchar(255) collate utf8_unicode_ci NOT NULL default '0',
  `postmodifiedat` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=133257 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_log`
-- 

CREATE TABLE `overload_log` (
  `id` int(11) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip` varchar(30) collate utf8_unicode_ci NOT NULL default '',
  `client` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `referer` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `page` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `pageversion` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `action` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `userid` int(4) NOT NULL default '1',
  `note` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_preferences`
-- 

CREATE TABLE `overload_preferences` (
  `userid` bigint(20) NOT NULL default '0',
  `stylesheetid` int(11) NOT NULL default '1',
  `nrcolumns_html` int(11) NOT NULL default '1',
  `nrcolumns_xul` int(11) NOT NULL default '1',
  `nritemsperpage_html` int(11) NOT NULL default '20',
  `nritemsperpage_xul` int(11) NOT NULL default '20',
  PRIMARY KEY  (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_tag`
-- 

CREATE TABLE `overload_tag` (
  `userid` bigint(20) NOT NULL,
  `itemid` bigint(20) NOT NULL,
  `kind` bigint(20) NOT NULL,
  `caption` varchar(255) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`userid`,`itemid`,`kind`,`caption`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_user`
-- 

CREATE TABLE `overload_user` (
  `userid` int(11) NOT NULL auto_increment,
  `username` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `password` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `surname` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `name` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `email` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `ip` varchar(15) collate utf8_unicode_ci NOT NULL default '',
  `restricttoip` int(1) NOT NULL default '0',
  `stylesheetid` int(11) NOT NULL default '0',
  `registerdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastvisit` datetime NOT NULL,
  `prevvisit` datetime NOT NULL,
  `status` int(11) NOT NULL default '0',
  `usercode` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  PRIMARY KEY  (`userid`),
  UNIQUE KEY `Username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=23 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_userfeed`
-- 

CREATE TABLE `overload_userfeed` (
  `id` bigint(20) NOT NULL auto_increment,
  `userid` bigint(20) NOT NULL default '0',
  `feedid` bigint(20) NOT NULL default '0',
  `groupid` bigint(20) NOT NULL default '0',
  `name` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `timestamp` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=120 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_usergroup`
-- 

CREATE TABLE `overload_usergroup` (
  `id` bigint(20) NOT NULL auto_increment,
  `userid` bigint(20) NOT NULL default '0',
  `name` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `folded` int(11) NOT NULL default '0',
  `timestamp` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=22 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `overload_useritem`
-- 

CREATE TABLE `overload_useritem` (
  `id` bigint(20) NOT NULL auto_increment,
  `userid` bigint(20) NOT NULL default '0',
  `itemid` bigint(20) NOT NULL default '0',
  `isread` int(11) NOT NULL default '0',
  `issaved` int(11) NOT NULL default '0',
  `tags` longtext collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=149352 ;

