<?php
	$skel["overload_html_version"] = "0.0.29";
	$skel["overload_html_lastmodified"] = "2006-01-09";

	require ("mod_html.php");

	$skel["stylesheet"] = $skel["overload_serverpath"] . "css/default.css";

	function buildNav($skel)
	{
		if (!isLoggedIn())
		{
			return "";
		}
		$result  = "<div id=\"nav\">\n";

		$feeds = getFeeds($skel, $_SESSION["userid"]);
		$_SESSION["overlaod_currentfeeds"] = $feeds;
		$result .= buildFeedTree($skel, $feeds, true);
		
		$result .= "</div>\n";
		return $result;
	}


	function buildPdaNav($skel, $userid)
	{
		$feeds = getFeeds($skel, $userid);
		$result .= buildFeedTree($skel, $feeds, false);
		
		return $result;
	}


	function buildSubnav($skel)
	{
		//check on isLoggedIn(), otherwise don't show subscribe etc. or do, but link to the "subscribe as new user" page
		$result  = "<div class=\"subnav\">\n";
		$result .= "\t<ul>\n";
		if (!isLoggedIn())
		{
			$result .= "\t\t<li><a href=\"./\">Home</a></li>\n";
			$result .= "\t\t<li><a href=\"subscribe.php\">Subscribe as new user</a></li>\n";
		}
		if (isLoggedIn())
		{
			$result .= "\t\t<li>Welcome " . $_SESSION["username"] . "</li>\n";
			$userid = $_SESSION["userid"];
			$result .= "\t\t<li>" . getTotalNumberOfUnreadItemsForUser($skel, $userid) . " unread in " . getTotalNumberOfFeedsForUser($skel, $userid) . " feeds</li>\n";
			//$result .= "\t\t<li><a href=\"manager.php?action=addfeed\">Add feed</a></li>\n";
			//$result .= "\t\t<li><a href=\"manager.php\">Manage feeds</a></li>\n";
			$result .= "\t\t<li><a href=\"manager.php\">Manage subscriptions</a></li>\n";
			//$result .= "\t\t<li><a href=\"options.php\">Options</a></li>\n";
		//}
		//$result .= "\t\t<li><a href=\"about.php\">About</a></li>\n";
		//if (isLoggedIn())
		//{
			$result .= "\t\t<li><a href=\"user.php\">Settings</a></li>\n";
			$result .= "\t\t<li><a href=\"xul/feedreader.php\">Rich client</a></li>\n";
			$result .= "\t\t<li><a href=\"index.php?action=logout\">Logout</a></li>\n";
		}
		$result .= "\t</ul>\n";
		$result .= "</div>\n\n";

		if (isLoggedIn())
		{
			$result .= "<div class=\"subnav\">\n";
			$result .= "\t<ul>\n";
			$result .= "\t\t<li><form class=\"subnavform\" action=\"feeds.php\" method=\"post\"><select name=\"filteritems\"><option value=\"new\">new</option><option value=\"all\">all</option><option value=\"saved\">saved only</option></select><select name=\"filterperiod\"><option value=\"all\">all in range</option><option value=\"day\">last 24 hours</option><option value=\"week\">last week</option><option value=\"month\">last 30 days</option></select><input type=\"submit\" class=\"button\" value=\"show\" /></form></li>\n";
			$result .= "\t\t<li><form class=\"subnavform\" action=\"search.php\" method=\"post\"><input type=\"text\" name=\"find\" /><input type=\"submit\" class=\"button\" value=\"find!\" /></form></li>\n";
			$result .= "\t</ul>\n";
			$result .= "</div>\n\n";
		}

		return $result;
	}


	function buildFooter($skel)
	{
		return "<div id=\"footer\">overload rss reader [<span title=\"engine version " . $skel["overload_version"] . " | page version " . $skel["overload_page_version"] . "/" . $skel["overload_page_lastmodified"] . "\">" . $skel["overload_release_version"] . "</span>] copyleft 2005-2006 <a href=\"http://aquariusoft.org/page/html/overload/\">Michiel Scholten</a> | content &copy; it's respective owners <span class=\"info\">build in " . round((getmicrotime() - $skel["parse_starttime"]), 4) . "sec</span></div>\n";
	}


/* ==== Data to html functions ==== */


	/*
	 * Build a page from a feed, including it's meta info
	 */
	function buildFeed($skel, $feed, $items, $currentpage, $totalpages, $writeenabled, $singleitem = false)
	{
//$timer = getmicrotime();

		$result  = "<div id=\"feed\">\n";
		$result .= feedToHTML($skel, $feed, $writeenabled);

//$result .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
//$timer = getmicrotime();

		$userid = -1;
		if (isset($_SESSION["userid"]))
		{
			$userid = $_SESSION["userid"];
		} else if (isset($skel["userid"]))
		{
			$userid = $skel["userid"];
		}
		$usercode = "";
		if (!$writeenabled)
		{
			$usercode = "&amp;usercode=" . $skel["usercode"];
		}

		$previous = "&lt;prev";
		$page2use = "feeds.php";
		if (!$writeenabled)
		{
			$page2use = "pda.php";
		}
		if ($currentpage > 2)
		{
			$previous = "<a href=\"" . $page2use . "?feedid=" . $feed["id"] . "&amp;page=" . ($currentpage - 1) . "\">&lt;prev</a>";
		}
		if ($currentpage == 2)
		{
			$previous = "<a href=\"" . $page2use . "?feedid=" . $feed["id"] . "\">&lt;prev</a>";
		}
		$next = "next&gt;";
		if ($currentpage < $totalpages)
		{
			$next = "<a href=\"" . $page2use . "?feedid=" . $feed["id"] . "&amp;page=" . ($currentpage + 1) . "\">next&gt;</a>";
		}
		//$nav = "<div class=\"feednav\">[ ";
		$nav = "<li>Pages: " . $currentpage . " of " . $totalpages . " " . $previous . " " . $next;
		if ($feed["id"] == -1)
		{
			$totalnrofitems = count($items);
		} else
		{
			$totalnrofitems = getNumberOfUnreadItems($skel, $skel["userid"], $feed["id"]);
		}
		$nav .= "</li><li>" . count($items) . " of " . $totalnrofitems . " items";
		if ($feed["lastupdate"] == "0000-00-00 00:00:00")
		{
			$nav .="</li><li>Feed will be updated shortly";
		} else
		{
			$nav .= "</li><li>Updated: " . $feed["lastupdate"];
		}
		if ($feed["lastupdatesuccessful"] != 1)
		{
			$nav .= " [not successful last time]";
		}
		//$nav .= " ]</div>\n";
		//$result .= $nav;
		$nav .= "</li>";

		$buttonnav = "";
		if ($writeenabled)
		{
			/* record current items for the "mark read" button [form] */
			$currentitems = "";
			for ($i = 0; $i < count($items); $i++)
			{
				$currentitems .= $items[$i]["id"] . " ";
			}
			$buttonnav .= "<div class=\"subnav\">\n";
			$buttonnav .= "\t<ul>\n";
			$buttonnav .= "\t\t<li><form class=\"subnavform\" action=\"feeds.php?feedid=" . $feed["id"] . "&amp;page=" . $currentpage . "&amp;action=markitemsread\" method=\"post\">";
			$buttonnav .= "<input type=\"hidden\" name=\"currentitems\" value=\"" . $currentitems . "\"/>";
			$buttonnav .= "<input type=\"submit\" class=\"button\" name=\"markread\" value=\"Mark this page Read\"/>";
			//$buttonnav .= "</form></li>\n";
			$buttonnav .= "</form>";
			if ($feed["id"] != -1)
			{
				$buttonnav .= "<form class=\"subnavform\" action=\"feeds.php?feedid=" . $feed["id"] . "&amp;page=" . $currentpage . "&amp;action=markfeedread\" method=\"post\">";
				$buttonnav .= "<input type=\"submit\" class=\"button\" name=\"markfeedread\" value=\"Mark whole feed Read\"/>";
				$buttonnav .= "</form></li>\n";
			}
			//$buttonnav .= "\t\t<li>" . $nav . "</li>\n";
			$buttonnav .= "\t\t" . $nav . "\n";
			$buttonnav .= "\t</ul>\n</div>\n";
		}

		$result .= $buttonnav;

		$result .= "<div id=\"items\">\n";

//$result .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
//$timer = getmicrotime();

		$result .= itemsToHTML($skel, $items, $writeenabled, $singleitem);

//$result .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
//$timer = getmicrotime();

		$result .= "</div>\n";
		$result .= $buttonnav;
		//$result .= $nav;
		$result .= "</div>\n";
		return $result;
	}


	function feedToHTML($skel, $feed)
	{
		$feedname = $feed["name"];
		if ($feed["userfeedname"] != "")
		{
			$feedname = $feed["userfeedname"];
		}

		$result  = "<div class=\"feedinfo\">\n";
		if ($feed["feedimage"] != "")
		{
			$result .= "\t<div class=\"feedimage\"><img src=\"" . $feed["feedimage"] . "\" alt=\"Feed logo\" title=\"" . $feed["feedimagedesc"] . "\" /></div>\n";
		}
		$result .= "\t<h1><a href=\"" . $feed["siteuri"] . "\">" . $feedname . "</a></h1>\n";
		$result .= "\t<div class=\"feedsubtitle\">" . $feed["subtitle"] . "</div>\n";
		if ($feed["lastupdatesuccessful"] == "0")
		{
			$result .= "\t<div class=\"error\">Last update not succesful!</div>\n";
		}
		$result .= "</div>\n";
		return $result;
	}


	function itemsToHTML($skel, $items, $writeenabled = false, $singleitem = false)
	{
		$result = "";
		if ($items == null)
		{
			return "<p><em>No unread items</em></p>\n";
		} else
		{
			$nrColumns = $skel["overload_nrcolumns_html"];
			if ($nrColumns > 1)
			{
				$currentColumn = 1;
				$result .= "<div class=\"feeditemrow\">\n";
			}

			$itemids = array();
			for ($i = 0; $i < count($items); $i++)
			{
				$itemids[$i] = $items[$i]["id"];
			}
			$uris = array();
			for ($i = 0; $i < count($items); $i++)
			{
				$uris[$i] = $items[$i]["uri"];
			}
			$relatedItems = null;
			$linkingItems = null;
			if ($writeenabled)
			{
				$relatedItems = findRelatedItems($skel, $_SESSION["userid"], $itemids);
				//$linkingItems = findLinkingItems($skel, $_SESSION["userid"], $itemids, $uris);
			}

			for ($i = 0; $i < count($items); $i++)
			{
				$result .= "<div class=\"feeditem\">\n";
				$result .= "\t<div class=\"feeditemmeta\">\n";
				$result .= "\t<h2><a href=\"" . $items[$i]["uri"] . "\">" . toUTF8($items[$i]["title"]) . "</a></h2>\n";
				$result .= "\t\t<div class=\"feedname\">Feed: <a href=\"feeds.php?feedid=" . $items[$i]["feedid"] . "\">" .  getFeedname($items[$i]) . "</a></div>\n";
				$result .= "\t\t<div class=\"feeditemdate\">Posted: " . date("Y-m-d H:i:s", $items[$i]["datetimestamp"]) . "</div>\n";
				if ($items[$i]["postmodifiedat"] != "0000-00-00 00:00:00")
				{
					$result .= "\t\t<div class=\"feeditemdate\">[Updated: " . $items[$i]["postmodifiedat"] . "]</div>\n";
				}
				if ($items[$i]["author"] != "")
				{
					$result .= "\t\t<div class=\"author\">Author: " . toUTF8($items[$i]["author"]) . "</div>\n";
				}

				$result .= "\t</div>\n";

				$result .= "\t<div class=\"feeditemcontent\">" . toUTF8($items[$i]["content"]) . "\n";

				if ($items[$i]["content"] == "")
				{
					//$result .= "<p>This item only contains a link. <a href=\"" . $items[$i]["uri"] . "\">Visit link</a></p>";
					$result .= "<p>This item doesn't have content. <a href=\"" . $items[$i]["uri"] . "\">Visit the link where it points to</a></p>";
				}

				/* related items */
				$result .= "\t\t<div class=\"related\">\n";

				$enclosures = getEnclosures($skel, $items[$i]["id"]);
				if ($enclosures != null && count($enclosures) > 0)
				{
					$result .= buildEnclosures($skel, $enclosures, $items[$i]["id"]);
				}

				if ($items[$i]["hasuris"] > 0 && $writeenabled && count($relatedItems) > 0)
				{
					$result .= buildRelatedItems($skel, $relatedItems, $items[$i]["id"], "Items maybe relevant to this post [sharing links]");
				}

				if (count($linkingItems) > 0 && $writeenabled)
				{
					$result .= buildRelatedItems($skel, $linkingItems, $items[$i]["id"], "Items linking to this post");
				}
				$result .= "\t\t</div>\n";
				/* /related items */

				if ($writeenabled)
				{
					$result .= "\t\t<div class=\"feediteminfo\">";
					if ($items[$i]["isread"] == 0)
					{
						$result .= "<a href=\"javascript:toggleRead(" . $items[$i]["id"] . ");\" id=\"read_" . $items[$i]["id"] . "\"><img src=\"img/newitem.png\" id=\"imgread_" . $items[$i]["id"] . "\" title=\"mark item Read\" /></a>";
					} else
					{
						$result .= "<a href=\"javascript:toggleRead(" . $items[$i]["id"] . ");\" id=\"read_" . $items[$i]["id"] . "\"><img src=\"img/item.png\" id=\"imgread_" . $items[$i]["id"] . "\" title=\"mark item UNRead\" /></a>";
					}
					if ($items[$i]["issaved"] == 0)
					{
						$result .= " <a href=\"javascript:toggleFlag(" . $items[$i]["id"] . ");\"><img src=\"" . $skel["overload_img_flag"] . "\" id=\"imgflag_" . $items[$i]["id"] . "\" title=\"flag item\" /></a>";
					} else if ($items[$i]["issaved"] == 1)
					{
						$result .= " <a href=\"javascript:toggleFlag(" . $items[$i]["id"] . ");\"><img src=\"" . $skel["overload_img_flagged"] . "\" id=\"imgflag_" . $items[$i]["id"] . "\" title=\"unflag item\" /></a>";
					}
					//$result .= " <a href=\"feeds.php?feedid=" . $items[$i]["feedid"] . "&amp;itemid=" . $items[$i]["id"] . "\">View only this item</a>";
					if (!$singleitem && !isXULPage($skel))
					{
						$result .= " <a href=\"feeds.php?feedid=" . $items[$i]["feedid"] . "&amp;itemid=" . $items[$i]["id"] . "\"><img src=\"img/showitem.png\" alt=\"View only this item\" title=\"View only this item\" /></a>";
					} else if (!isXULPage($skel))
					{
						$result .= " <a href=\"feeds.php?feedid=" . $items[$i]["feedid"] . "\"><img src=\"img/showfeed.png\" alt=\"Show this feed\" title=\"Show this feed\" /></a>";
					}
					$result .= "\n\t\t</div>\n";
				}

				$result .= "\t</div>\n";


				$result .= "</div>\n";
				if ($nrColumns > 1)
				{
					$currentColumn++;
					if ($currentColumn > $nrColumns)
					{
						$result .= "</div>\n";
						$currentColumn -= $nrColumns;
						if (($i + 1) < count($items))
						{
							$result .= "<div class=\"feeditemrow\">\n";
						}
					}
				}
			}
			if ($nrColumns > 1)
			{
				if ($currentColumn < $nrColumns && $currentColumn != 1)
				{
					$result .= "</div>\n";
				}
			}
		}
		return $result;
	}


	function buildRelatedItems($skel, $relatedItems, $itemid, $title)
	{
		$result = "";
		for ($i = 0; $i < count($relatedItems); $i++)
		{
			if ($relatedItems[$i]["thisitem"] == $itemid)
			{
				$item = $relatedItems[$i]["item"];
				$feedname = "";
				for ($j = 0; $j < count($_SESSION["overlaod_currentfeeds"]); $j++)
				{
					if ($_SESSION["overlaod_currentfeeds"][$j]["id"] == $item["feedid"])
					{
						$feedname = $_SESSION["overlaod_currentfeeds"][$j]["feedname"];
						if ($_SESSION["overlaod_currentfeeds"][$j]["userfeedname"] != "")
						{
							$feedname = $_SESSION["overlaod_currentfeeds"][$j]["userfeedname"];
						}
					}
				}
				$result .= "\t\t\t<li>[" . $feedname . "] <a href=\"feeds.php?feedid=" . $item["feedid"] . "&amp;itemid=" . $item["id"] . "\">" . $item["title"] . "</a> [<a href=\"" . $item["uri"] . "\">website</a>]</li>\n";
			}
		}
		if ($result != "")
		{
			$result = "\t\t<ul>\n" . $result;
			$result = "\t\t<p>" . $title . ":</p>\n" . $result;
			$result .= "\t\t</ul>\n";

			$result .= "\t\t<div>view all | mark all Read</div>\n";
		}
		return $result;
	}

	function buildEnclosures($skel, $enclosures, $itemid)
	{
		$result = "";
		for ($i = 0; $i < count($enclosures); $i++)
		{
			$result .= "\t<li><a href=\"" . $enclosures[$i]["uri"] . "\">File " . ($i + 1) . "</a> [type: " . $enclosures[$i]["mimetype"] . ", length/size: " . $enclosures[$i]["length"] . "]</li>\n";
		}
		if ($result != "")
		{
			$result = "\t\t<ul>\n" . $result;
			$result = "\t\t<p>Enclosures for this item:</p>\n" . $result;
			$result .= "\t\t</ul>\n";
		}
		return $result;
	}


	function buildFeedTree($skel, $feeds, $writeenabled)
	{
		//$userid = $_SESSION["userid"];
		//$result = "<div class=\"feednav\">" . getTotalNumberOfUnreadItemsForUser($skel, $userid) . " unread in " . getTotalNumberOfFeedsForUser($skel, $userid) . " feeds</div>\n";
		$result .= "<ul>\n";
		$groupname = "";
		$grouplevel = 0;
//$timer = getmicrotime();
		$unreadItemsInFeeds = -1;
		if (isset($skel["userid"]))
		{
			$unreadItemsInFeeds = getNumberOfUnreadItemsPerFeed($skel, $skel["userid"]);
		} else if (isset($_SESSION["userid"]))
		{
			$unreadItemsInFeeds = getNumberOfUnreadItemsPerFeed($skel, $_SESSION["userid"]);
		}
//$result .= "<!-- test " . (getmicrotime() - $timer) . "-->\n";
		//print_r($blah);
		for ($i = 0; $i < count($feeds); $i++)
		{
			$nrofunread = $unreadItemsInFeeds[$feeds[$i]["id"]]["unread"];
			if ($nrofunread == null)
			{
				$nrofunread = 0;
			}

			$page = "feeds.php";
			$usercode = "";
			if (!$writeenabled)
			{
				$page = "pda.php";
				$usercode = "&amp;usercode=" . $skel["usercode"];
			}
			
			if ($feeds[$i]["groupname"] != $groupname)
			{
				if ($groupname != "")
				{
					//close previous group
					$result .= "\t\t</ul>\n\t</li>\n";
				}

				$groupname = $feeds[$i]["groupname"];
				$grouplevel = 1;
				$result .= "\t<li class=\"group\">" . $groupname . "\n\t\t<ul>\n";
			}
			$feedname = $feeds[$i]["feedname"];
			if ($feeds[$i]["userfeedname"] != "")
			{
				$feedname = $feeds[$i]["userfeedname"];
			}
			$unread = "";
			if ($nrofunread > 0)
			{
				$unread = " class=\"unread\"";
			}
			$error = "";
			if ($feeds[$i]["lastupdatesuccessful"] != 1)
			{
				$error = "<span class=\"error\" title=\"There was a problem fetching this feed\">[!]</span>";
			}
			
			$result .= "\t\t\t<li" . $unread . ">" . $error . "<a href=\"" . $page . "?feedid=" . $feeds[$i]["id"] . $usercode . "\">" . $feedname . "</a>";
			if ($nrofunread > 0)
			{
				$result .= " (" . $nrofunread . ")";
			}
			$result .= "</li>\n";
		}
		if ($grouplevel = 1)
		{
			$result .= "\t\t</ul>\n\t</li>\n";
		}
		$result .= "</ul>\n";
		return $result;
	}


        function buildGroupList($skel, $groups)
	{
		$result = "<ul>\n";
		for ($i = 0; $i < count($groups); $i++)
		{
			$result .= "\t<li><a href=\"manager.php?action=editgroup&amp;groupid=" . $groups[$i]["id"] . "\">" . $groups[$i]["name"] . "</a> [<a href=\"manager.php?action=deletegroup&amp;groupid=" . $groups[$i]["id"] . "\">delete</a>]</li>\n";
		}
		$result .= "</ul>\n";
		return $result;
	}

	function buildFlatGroupList($skel, $groups)
	{
		for ($i = 0; $i < count($groups); $i++)
		{
			$result .= "\t<div><a href=\"manager.php?action=editgroup&amp;groupid=" . $groups[$i]["id"] . "\">" . $groups[$i]["name"] . "</a></div>\n";
		}
		return $result;
	}

	function isXULPage($skel)
	{
		return (isset($skel["xul_page"]) && $skel["xul_page"]  == true);
	}

?>
