<?php
	/*
	 * Depends on magpie
	 * http://magpierss.sourceforge.net/
	 */

	header('Content-type: text/html; charset=utf8');

	require ("modules/mod_overload_html_pages.php");

	$skel["overload_page_version"] = pageFeedsVersion();
	$skel["overload_page_lastmodified"] = pageFeedsModified();

	$page_title = "Feeds";


	//$body .= "<div id=\"logo\">overload</div>\n";
	$body .= "<div id=\"logo\"><a href=\"feeds.php\"><img src=\"img/overload_logo.png\" alt=\"overload\" /></a></div>\n";
	$body .= buildNav($skel);
	$body .= "<div id=\"content\">\n";
	$body .= buildSubnav($skel);

	/* Check if user is logged in */
	if (!isLoggedIn())
	{
		$body .= buildNotLoggedIn($skel);
	} else
	{
		$feedid = getRequestParam("feedid", -1);
		$itemid = getRequestParam("itemid", -1);
		$page = getRequestParam("page", 1);
		$action = getRequestParam("action", null);

		if ($itemid != -1)
		{
			/* We're showing one item, so let it take the whole width */
			$skel["overload_nrcolumns_html"] = 1;
		}

		if ($action == "markitemsread")
		{
			$userid = $_SESSION["userid"];
			setItemsRead($skel, $userid, $_REQUEST["currentitems"]);
		} else if ($action == "markfeedread")
		{
			$userid = $_SESSION["userid"];
			setFeedRead($skel, $userid, $feedid);
		}

		$body .= pageFeeds($skel, $feedid, $page, $itemid);
	}

	$body .= buildFooter($skel);
	$body .= "</div>\n";

	$feedname = "";
	if ($currentfeed != null)
	{
		$feedname = $currentfeed["name"];
		if ($currentfeed["username"] != "")
		{
			$feedname = $currentfeed["username"];
		}
		$feedname = " > " . $feedname;
	}
	echo generatePage($skel, $skel["overload_title"] . " | " . $page_title . $feedname, $body);
?>
